/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import com.devexperts.mdd.news.event.NewsKey;
import com.devexperts.mdd.news.event.NewsOrigin;
import com.devexperts.util.TimeFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NewsEvent
implements Serializable,
Comparable<NewsEvent> {
    private static final long serialVersionUID = 1L;
    public static final String MESSAGE_SYMBOL = "NEWS";
    private final NewsKey key;
    private final String feed;
    private final String sourceId;
    private final String source;
    private final long time;
    private final String title;
    private transient NewsOrigin origin;
    private final String body;
    private final List<String> symbols;
    private final Map<String, List<String>> tags;

    protected NewsEvent(Builder builder) {
        this.key = Objects.requireNonNull(builder.key, "key");
        this.feed = NewsEvent.notNull("feed", builder.feed);
        this.sourceId = NewsEvent.notNull("sourceId", builder.sourceId);
        this.source = NewsEvent.notNull("source", builder.source);
        this.origin = NewsOrigin.valueOf(this.feed, this.source);
        this.title = NewsEvent.notNull("title", builder.title);
        this.time = builder.time;
        if (this.time <= 0L) {
            throw new IllegalArgumentException("Illegal 'time': invalid time");
        }
        this.body = builder.body == null || builder.body.isEmpty() ? null : builder.body;
        this.symbols = NewsEvent.immutableNonEmptyList(builder.symbols);
        this.tags = NewsEvent.immutableMap(builder.tags);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public NewsKey getKey() {
        return this.key;
    }

    public String getFeed() {
        return this.feed;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSource() {
        return this.source;
    }

    public NewsOrigin getOrigin() {
        return this.origin;
    }

    public long getTime() {
        return this.time;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getSymbols() {
        return this.symbols;
    }

    public Map<String, List<String>> getTags() {
        return this.tags;
    }

    @Override
    public int compareTo(NewsEvent o) {
        return this.getKey().getCode().compareTo(o.getKey().getCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NewsEvent) {
            NewsEvent that = (NewsEvent)o;
            return this.getKey().equals(that.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "NewsEvent{" + this.key.getCode() + "/" + this.getSourceId() + ", time=" + TimeFormat.DEFAULT.format(this.getTime()) + ", feed=" + this.feed + ", title=" + this.title + "}";
    }

    private static String notNull(String name, String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Illegal '" + name + "': empty or null value");
        }
        return value;
    }

    private static List<String> immutableNonEmptyList(List<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<String>(values));
    }

    private static Map<String, List<String>> immutableMap(Map<String, List<String>> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> copy = new LinkedHashMap<String, List<String>>(map);
        copy.replaceAll((k, values) -> Collections.unmodifiableList(new ArrayList(values)));
        return Collections.unmodifiableMap(copy);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.origin = NewsOrigin.valueOf(this.feed, this.source);
    }

    public static class Builder {
        private NewsKey key;
        private String feed;
        private String sourceId;
        private String source;
        private long time;
        private String title;
        private String body;
        private List<String> symbols;
        private final Map<String, List<String>> tags = new LinkedHashMap<String, List<String>>();

        protected Builder() {
        }

        public Builder withKey(NewsKey key) {
            this.key = key;
            return this;
        }

        public Builder withFeed(String feed) {
            this.feed = feed;
            return this;
        }

        public Builder withSourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder withTime(long time) {
            this.time = time;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withBody(String body) {
            this.body = body;
            return this;
        }

        public Builder withSymbols(List<String> symbols) {
            this.symbols = symbols != null && !symbols.isEmpty() ? new ArrayList<String>(symbols) : null;
            return this;
        }

        public Builder withTags(Map<String, List<String>> values) {
            if (values != null && !values.isEmpty()) {
                values.forEach(this::withTag);
            }
            return this;
        }

        public Builder withTag(String tag, List<String> values) {
            if (tag != null && !tag.isEmpty()) {
                if (values != null && !values.isEmpty()) {
                    this.tags.put(tag, new ArrayList<String>(values));
                } else {
                    this.tags.remove(tag);
                }
            }
            return this;
        }

        public Builder addTag(String tag, String value) {
            if (tag != null && !tag.isEmpty() && value != null && !value.isEmpty()) {
                this.tags.computeIfAbsent(tag, k -> new ArrayList()).add(value);
            }
            return this;
        }

        public NewsEvent build() {
            NewsEvent event = new NewsEvent(this);
            return event;
        }
    }
}

