/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import com.devexperts.mdd.news.event.NewsEvent;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;

public final class NewsOrigin
implements Serializable {
    public static final NewsOrigin ANY = new NewsOrigin("*", "*");
    public static final NewsOrigin NOTHING = new NewsOrigin();
    private final String feed;
    private final String source;
    private static final Pattern FEED_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]*$");

    public static NewsOrigin valueOf(String origin) {
        Objects.requireNonNull(origin, "origin");
        if (origin.isEmpty()) {
            return NOTHING;
        }
        int semicolon = origin.indexOf(58);
        if (semicolon == -1) {
            semicolon = origin.length();
        }
        String feed = origin.substring(0, semicolon);
        String source = semicolon + 1 < origin.length() ? origin.substring(semicolon + 1) : "*";
        return NewsOrigin.valueOf(feed, source);
    }

    public static NewsOrigin valueOf(String feed, String source) {
        NewsOrigin.checkFeedFormat(feed);
        Objects.requireNonNull(source, "source");
        if (feed.isEmpty() && source.isEmpty()) {
            return NOTHING;
        }
        if (("*".equals(feed) || feed.isEmpty()) && ("*".equals(source) || source.isEmpty())) {
            return ANY;
        }
        return new NewsOrigin(feed.isEmpty() ? "*" : feed, source.isEmpty() ? "*" : source);
    }

    public static NewsOrigin valueOf(NewsEvent event) {
        Objects.requireNonNull(event, "event");
        return new NewsOrigin(event.getFeed(), event.getSource());
    }

    private NewsOrigin(String feed, String source) {
        this.feed = feed;
        this.source = source;
    }

    private NewsOrigin() {
        this.feed = "";
        this.source = "";
    }

    public String getFeed() {
        return this.feed;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isFeedWildcard() {
        return "*".equals(this.feed);
    }

    public boolean isSourceWildcard() {
        return "*".equals(this.source);
    }

    public boolean isSourceUseWildCardPrefixFilter() {
        return this.source != null && this.source.endsWith("*") && !this.source.equals("*");
    }

    public boolean isWildcard() {
        return this.isFeedWildcard() && this.isSourceWildcard();
    }

    public boolean isExact() {
        return !this.isFeedWildcard() && !this.isSourceWildcard() && !this.feed.isEmpty() && !this.source.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewsOrigin that = (NewsOrigin)o;
        return this.feed.equals(that.feed) && this.source.equals(that.source);
    }

    public int hashCode() {
        return Objects.hash(this.feed, this.source);
    }

    public String toString() {
        return this.feed.isEmpty() && this.source.isEmpty() ? "" : this.feed + ":" + this.source;
    }

    private static void checkFeedFormat(String feed) {
        Objects.requireNonNull(feed, "feed");
        if (feed.isEmpty() || "*".equals(feed)) {
            return;
        }
        if (FEED_PATTERN.matcher(feed).matches()) {
            return;
        }
        throw new IllegalArgumentException("Invalid feed name \"" + feed + "\"");
    }
}

