/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import com.devexperts.mdd.news.event.NewsOrigin;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class NewsFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String FILTER_FEED = "feed";
    @Deprecated
    public static final String FILTER_SOURCE = "source";
    public static final String FILTER_ORIGIN = "origin";
    public static final String FILTER_SYMBOL = "symbol";
    @Deprecated
    public static final String FILTER_LIMIT = "limit";
    @Deprecated
    public static final String FILTER_DATE_LIMIT = "dateLimit";
    @Deprecated
    public static final String FILTER_INTERVAL_LIMIT = "intervalLimit";
    @Deprecated
    public static final String FILTER_TIMEOUT = "timeout";
    public static final String FILTER_CHAIN_ID = "chainId";
    public static final String FILTER_ACTUAL_ONLY = "actualOnly";
    public static final String FILTER_INCLUDE_EXTRA_ATTRIBUTES = "includeExtraAttributes";
    public static final String FILTER_INCLUDE_BODY = "includeBody";
    public static final String FILTER_INCLUDE_RAW_NEWS = "includeRawNews";
    public static final String FILTER_LATEST_PER_SYMBOL = "latestPerSymbol";
    public static final String FILTER_TIMEFRAME = "timeframe";
    public static final Set<String> FILTER_PARAMETERS = new HashSet<String>();
    public static final NewsFilter EMPTY_FILTER;
    public static final int DEFAULT_LIMIT = 100;
    public static final long DEFAULT_TIMEOUT = 3600000L;
    public static final long DEFAULT_DATE_LIMIT = Long.MIN_VALUE;
    public static final long DEFAULT_INTERVAL_LIMIT = Long.MAX_VALUE;
    public static final long DEFAULT_TIMEFRAME = Long.MAX_VALUE;
    private final Map<String, Set<String>> params;
    private transient int limit;
    private transient long timeout;
    private transient Set<NewsOrigin> origins;
    private transient long dateLimit;
    private transient long intervalLimit;
    private transient boolean actualOnly;
    private transient boolean includeBody;
    private transient boolean includeExtraAttributes;
    private transient boolean includeRawNews;
    private transient boolean latestPerSymbol;
    private transient long timeframe;
    private final Map<String, String> tags;

    protected NewsFilter(Map<String, Set<String>> params, Map<String, String> tags, int originLimits) {
        this.params = NewsFilter.immutableMap(params);
        this.tags = tags;
        this.initialize(originLimits);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static NewsFilter limitFilter(int limit) {
        return NewsFilter.newBuilder().withLimit(limit).build();
    }

    public static NewsFilter emptyFilter() {
        return EMPTY_FILTER;
    }

    public Builder builder() {
        return new Builder().withParams(this.getParams());
    }

    @Deprecated
    public Set<String> getFeeds() {
        return this.getParam(FILTER_FEED);
    }

    @Deprecated
    public Set<String> getSources() {
        return this.getParam(FILTER_SOURCE);
    }

    public Set<NewsOrigin> getOrigins() {
        return this.origins;
    }

    public Set<String> getSymbols() {
        return this.getParam(FILTER_SYMBOL);
    }

    public Set<String> getChainIds() {
        return this.getParam(FILTER_CHAIN_ID);
    }

    public boolean isActualOnly() {
        return this.actualOnly;
    }

    public boolean isLatestPerSymbol() {
        return this.latestPerSymbol;
    }

    public boolean includeBody() {
        return this.includeBody;
    }

    public boolean includeExtraAttributes() {
        return this.includeExtraAttributes;
    }

    public boolean includeRawNews() {
        return this.includeRawNews;
    }

    public long getTimeframe() {
        return this.timeframe;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getDateLimit() {
        return this.dateLimit;
    }

    public long getIntervalLimit() {
        return this.intervalLimit;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Map<String, Set<String>> getParams() {
        return this.params;
    }

    public Set<String> getParam(String name) {
        return this.params.get(name);
    }

    public String toString() {
        return "NewsFilter{" + this.getParams() + "}";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize(10);
    }

    protected void initialize(int originsLimit) {
        this.limit = (int)NewsFilter.validPositiveNumber(FILTER_LIMIT, this.getParam(FILTER_LIMIT), 100L);
        this.timeout = NewsFilter.validPositiveNumber(FILTER_TIMEOUT, this.getParam(FILTER_TIMEOUT), 3600000L);
        this.dateLimit = NewsFilter.validNumber(FILTER_DATE_LIMIT, this.getParam(FILTER_DATE_LIMIT), Long.MIN_VALUE);
        this.timeframe = NewsFilter.validPositiveNumber(FILTER_TIMEFRAME, this.getParam(FILTER_TIMEFRAME), Long.MAX_VALUE);
        this.intervalLimit = NewsFilter.validNumber(FILTER_INTERVAL_LIMIT, this.getParam(FILTER_INTERVAL_LIMIT), Long.MAX_VALUE);
        this.actualOnly = NewsFilter.validBoolean(this.getParam(FILTER_ACTUAL_ONLY), false);
        this.includeRawNews = NewsFilter.validBoolean(this.getParam(FILTER_INCLUDE_RAW_NEWS), true);
        this.includeExtraAttributes = NewsFilter.validBoolean(this.getParam(FILTER_INCLUDE_EXTRA_ATTRIBUTES), true);
        this.includeBody = NewsFilter.validBoolean(this.getParam(FILTER_INCLUDE_BODY), true);
        this.latestPerSymbol = NewsFilter.validBoolean(this.getParam(FILTER_LATEST_PER_SYMBOL), false);
        NewsFilter.validateSet(FILTER_SYMBOL, this.getParam(FILTER_SYMBOL), 10L);
        NewsFilter.validateSet(FILTER_FEED, this.getParam(FILTER_FEED), 10L);
        NewsFilter.validateSet(FILTER_SOURCE, this.getParam(FILTER_SOURCE), 10L);
        NewsFilter.validateSet(FILTER_ORIGIN, this.getParam(FILTER_ORIGIN), originsLimit);
        Set<NewsOrigin> origins = NewsFilter.calculateOrigins(this.getParam(FILTER_ORIGIN), this.getParam(FILTER_FEED), this.getParam(FILTER_SOURCE));
        this.origins = origins.isEmpty() ? null : Collections.unmodifiableSet(origins);
    }

    protected static Set<NewsOrigin> calculateOrigins(Set<String> os, Set<String> fs, Set<String> ss) {
        LinkedHashSet<NewsOrigin> origins = new LinkedHashSet<NewsOrigin>();
        if (os != null && !os.isEmpty()) {
            os.stream().map(NewsOrigin::valueOf).forEachOrdered(origins::add);
        }
        if (fs == null && ss != null) {
            fs = Collections.singleton("*");
        }
        if (fs != null && ss == null) {
            ss = Collections.singleton("*");
        }
        if (fs != null && ss != null) {
            for (String s : ss) {
                String source;
                String prefix;
                if (s.indexOf(45) >= 0) {
                    String[] sourceParts = s.split("-");
                    prefix = sourceParts[0].trim();
                    source = sourceParts[1].trim();
                } else if ("*".equals(s)) {
                    prefix = "*";
                    source = "*";
                } else {
                    prefix = "";
                    source = s;
                }
                for (String feed : fs) {
                    origins.add(NewsOrigin.valueOf(feed, prefix, source));
                }
            }
        }
        return origins;
    }

    private static Map<String, Set<String>> immutableMap(Map<String, Set<String>> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Set<String>> copy = new LinkedHashMap<String, Set<String>>(map);
        copy.replaceAll((k, values) -> Collections.unmodifiableSet(new LinkedHashSet(values)));
        return Collections.unmodifiableMap(copy);
    }

    private static long validPositiveNumber(String name, Collection<String> values, long defValue) {
        long value = NewsFilter.validNumber(name, values, defValue);
        if (value < 1L) {
            throw new IllegalArgumentException("Illegal '" + name + "': " + value + " must be positive");
        }
        return value;
    }

    private static long validNumber(String name, Collection<String> values, long defValue) {
        long value;
        if (values == null || values.isEmpty()) {
            return defValue;
        }
        try {
            value = Long.parseLong(values.iterator().next());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal '" + name + "': value is not a number");
        }
        return value;
    }

    private static boolean validBoolean(Collection<String> values, boolean defValue) {
        if (values == null || values.isEmpty()) {
            return defValue;
        }
        return Boolean.parseBoolean(values.iterator().next());
    }

    private static void validateSet(String name, Collection<String> values, long maxValue) {
        if (values != null && (long)values.size() > maxValue) {
            throw new IllegalArgumentException("Illegal '" + name + "': filter is too large");
        }
    }

    static {
        FILTER_PARAMETERS.add(FILTER_FEED);
        FILTER_PARAMETERS.add(FILTER_SOURCE);
        FILTER_PARAMETERS.add(FILTER_SYMBOL);
        FILTER_PARAMETERS.add(FILTER_ORIGIN);
        FILTER_PARAMETERS.add(FILTER_LIMIT);
        FILTER_PARAMETERS.add(FILTER_DATE_LIMIT);
        FILTER_PARAMETERS.add(FILTER_INTERVAL_LIMIT);
        FILTER_PARAMETERS.add(FILTER_TIMEOUT);
        FILTER_PARAMETERS.add(FILTER_CHAIN_ID);
        FILTER_PARAMETERS.add(FILTER_ACTUAL_ONLY);
        FILTER_PARAMETERS.add(FILTER_INCLUDE_RAW_NEWS);
        FILTER_PARAMETERS.add(FILTER_INCLUDE_BODY);
        FILTER_PARAMETERS.add(FILTER_INCLUDE_EXTRA_ATTRIBUTES);
        FILTER_PARAMETERS.add(FILTER_LATEST_PER_SYMBOL);
        FILTER_PARAMETERS.add(FILTER_TIMEFRAME);
        EMPTY_FILTER = NewsFilter.newBuilder().build();
    }

    public static class Builder {
        private final Map<String, Set<String>> params = new LinkedHashMap<String, Set<String>>();
        private Map<String, String> tags;

        protected Builder() {
        }

        public Builder withFeeds(String ... feeds) {
            return this.withParam(NewsFilter.FILTER_FEED, Arrays.asList(feeds));
        }

        public Builder withFeeds(Collection<String> feeds) {
            return this.withParam(NewsFilter.FILTER_FEED, feeds);
        }

        public Builder withSources(String ... sources) {
            return this.withParam(NewsFilter.FILTER_SOURCE, Arrays.asList(sources));
        }

        public Builder withSources(Collection<String> sources) {
            return this.withParam(NewsFilter.FILTER_SOURCE, sources);
        }

        public Builder withOrigins(NewsOrigin ... origins) {
            return this.withParam(NewsFilter.FILTER_ORIGIN, Arrays.stream(origins).map(NewsOrigin::toString).collect(Collectors.toList()));
        }

        public Builder withOrigins(Collection<NewsOrigin> origins) {
            return this.withParam(NewsFilter.FILTER_ORIGIN, ((Collection)Optional.ofNullable(origins).orElse(Collections.emptySet())).stream().map(NewsOrigin::toString).collect(Collectors.toList()));
        }

        public Builder withSymbols(String ... symbols) {
            return this.withParam(NewsFilter.FILTER_SYMBOL, Arrays.asList(symbols));
        }

        public Builder withSymbols(Collection<String> symbols) {
            return this.withParam(NewsFilter.FILTER_SYMBOL, symbols);
        }

        public Builder withChainIds(Collection<String> chainIds) {
            return this.withParam(NewsFilter.FILTER_CHAIN_ID, chainIds);
        }

        public Builder withLimit(int limit) {
            return this.withParam(NewsFilter.FILTER_LIMIT, String.valueOf(limit));
        }

        public Builder withTimeout(long timeout) {
            return this.withParam(NewsFilter.FILTER_TIMEOUT, String.valueOf(timeout));
        }

        public Builder withActualOnly(boolean actualOnly) {
            return this.withParam(NewsFilter.FILTER_ACTUAL_ONLY, String.valueOf(actualOnly));
        }

        public Builder withIncludeBody(boolean includeBody) {
            return this.withParam(NewsFilter.FILTER_INCLUDE_BODY, String.valueOf(includeBody));
        }

        public Builder withIncludeExtraAttributes(boolean includeExtraAttributes) {
            return this.withParam(NewsFilter.FILTER_INCLUDE_EXTRA_ATTRIBUTES, String.valueOf(includeExtraAttributes));
        }

        public Builder withIncludeRawNews(boolean includeRawNews) {
            return this.withParam(NewsFilter.FILTER_INCLUDE_RAW_NEWS, String.valueOf(includeRawNews));
        }

        public Builder withLatestPerSymbol(boolean latestPerSymbol) {
            return this.withParam(NewsFilter.FILTER_LATEST_PER_SYMBOL, String.valueOf(latestPerSymbol));
        }

        public Builder withTimeframe(long timeframe) {
            return this.withParam(NewsFilter.FILTER_TIMEFRAME, String.valueOf(timeframe));
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withParams(Map<String, Set<String>> filters) {
            if (filters != null && !filters.isEmpty()) {
                filters.forEach(this::withParam);
            }
            return this;
        }

        public Builder withParam(String filter, Collection<String> values) {
            if (filter != null && !filter.isEmpty()) {
                if (values != null && !values.isEmpty()) {
                    this.params.put(filter, new LinkedHashSet<String>(values));
                } else {
                    this.params.remove(filter);
                }
            }
            return this;
        }

        public Builder withParam(String filter, String value) {
            if (filter != null && !filter.isEmpty()) {
                if (value != null && !value.isEmpty()) {
                    this.params.put(filter, Collections.singleton(value));
                } else {
                    this.params.remove(filter);
                }
            }
            return this;
        }

        public NewsFilter build() {
            return new NewsFilter(this.params, this.tags == null ? null : Collections.unmodifiableMap(this.tags), 10);
        }
    }
}

