/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.model;

import com.devexperts.logging.Logging;
import com.devexperts.mdd.news.event.NewsEvent;
import com.devexperts.mdd.news.event.NewsFilter;
import com.devexperts.mdd.news.event.NewsKey;
import com.devexperts.mdd.news.model.NewsList;
import com.devexperts.mdd.news.model.NewsService;
import com.devexperts.mdd.news.model.ObservableNewsList;
import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.dxfeed.model.ObservableListModel;
import java.util.List;

public class NewsModel
implements Runnable {
    private static final RMIOperation<NewsList> FIND_NEWS_FOR_FILTER = RMIOperation.valueOf((String)NewsService.class.getName(), NewsList.class, (String)"findNewsForFilter", (Class[])new Class[]{NewsFilter.class, NewsKey.class});
    private final RMIEndpoint endpoint;
    private RMIRequest<NewsList> request;
    private volatile boolean live;
    private volatile boolean running;
    private volatile NewsFilter filter = NewsFilter.emptyFilter();
    private volatile NewsKey lastKey = NewsKey.FIRST_KEY;
    private final ObservableNewsList newsList = new ObservableNewsList();
    final Logging log = Logging.getLogging(this.getClass());

    public NewsModel(RMIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public NewsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(NewsFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter is null");
        }
        this.filter = filter;
        this.newsList.setLimit(filter.getLimit());
        if (this.request != null) {
            this.lastKey = NewsKey.FIRST_KEY;
            this.request.cancelOrAbort();
            this.newsList.beginChange();
            this.newsList.clear();
            this.newsList.endChange();
        }
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        if (this.live == live) {
            return;
        }
        this.live = live;
        if (this.shouldRun()) {
            this.endpoint.getClient().getDefaultExecutor().execute(this);
        } else if (this.request != null) {
            this.request.cancelOrAbort();
        }
    }

    public ObservableListModel<NewsEvent> getNewsList() {
        return this.newsList;
    }

    @Override
    public void run() {
        while (this.shouldRun() && !Thread.currentThread().isInterrupted()) {
            this.running = true;
            try {
                this.request = this.endpoint.getClient().createRequest(null, FIND_NEWS_FOR_FILTER, new Object[]{this.filter, this.lastKey});
                this.request.send();
                NewsList news = (NewsList)this.request.getBlocking();
                this.request = null;
                this.processNews(news);
            }
            catch (RMIException e) {
                if (e.getType() == RMIExceptionType.CANCELLED_BEFORE_EXECUTION || e.getType() == RMIExceptionType.CANCELLED_DURING_EXECUTION || e.getType() == RMIExceptionType.CANCELLED_AFTER_EXECUTION) continue;
                this.log.debug("RMI Exception: " + e.getType().getMessage());
            }
            catch (Throwable e) {
                this.log.debug("Exception while receiving news", e);
            }
            finally {
                this.running = false;
            }
        }
    }

    private void processNews(NewsList remoteNews) {
        this.lastKey = remoteNews.getLastKey();
        List<NewsEvent> list = remoteNews.getNews();
        this.newsList.beginChange();
        int i = list.size();
        while (--i >= 0) {
            this.newsList.addChange(list.get(i));
        }
        this.newsList.endChange();
    }

    private boolean shouldRun() {
        return !this.running && this.live;
    }
}

