/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.orcs;

import com.devexperts.logging.Logging;
import com.devexperts.util.TimeFormat;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PriceLevelChecker {
    private static final Logging log = Logging.getLogging(PriceLevelChecker.class);

    private PriceLevelChecker() {
    }

    public static boolean validate(List<Order> orders, long timeGapBound, boolean printQuotes) {
        if (orders.isEmpty()) {
            return true;
        }
        TreeMap<Double, Order> currentState = new TreeMap<Double, Order>();
        ArrayList<Order> curTimeOrders = new ArrayList<Order>();
        long curTime = Long.MIN_VALUE;
        long lastBboTime = Long.MIN_VALUE;
        double prevBid = Double.NaN;
        double prevAsk = Double.NaN;
        boolean valid = true;
        long timeGap = 0L;
        for (int i = 0; i < orders.size(); ++i) {
            Order order = orders.get(i);
            if (i != 0) {
                Order prevOrder = orders.get(i - 1);
                long curTimeGap = order.getTime() - prevOrder.getTime();
                if (curTimeGap > timeGapBound) {
                    log.warn("TIME_GAP_BOUND between: " + prevOrder + " - " + order);
                }
                timeGap = Math.max(timeGap, curTimeGap);
            }
            if (order.getTime() != curTime) {
                double bid = Double.NaN;
                double ask = Double.NaN;
                for (Order curOrder : currentState.values()) {
                    if (curOrder.getOrderSide() == Side.BUY && (Double.isNaN(bid) || bid < curOrder.getPrice())) {
                        bid = curOrder.getPrice();
                    }
                    if (curOrder.getOrderSide() != Side.SELL || !Double.isNaN(ask) && !(ask > curOrder.getPrice())) continue;
                    ask = curOrder.getPrice();
                }
                if (lastBboTime / 1000L != curTime / 1000L) {
                    if (!(Double.isNaN(prevAsk) || Double.isNaN(prevBid) || Double.isNaN(ask) || Double.isNaN(bid))) {
                        double bidSpike = (bid - prevBid) / prevBid;
                        double askSpike = (ask - prevAsk) / prevAsk;
                        if (printQuotes && (bidSpike >= 0.005 || askSpike >= 0.005)) {
                            log.warn("SPIKE: " + TimeFormat.DEFAULT.format(lastBboTime) + "=" + prevBid + "-" + prevAsk + TimeFormat.DEFAULT.format(curTime) + "=" + bid + "-" + ask);
                        }
                    }
                    prevBid = bid;
                    prevAsk = ask;
                    lastBboTime = curTime;
                    if (printQuotes) {
                        log.info("time=" + TimeFormat.GMT.format(lastBboTime) + ", bid=" + prevBid + ", ask=" + prevAsk);
                    }
                }
                for (Order curOrder : curTimeOrders) {
                    Order nextOrder;
                    if (curOrder.getOrderSide() == Side.BUY) {
                        Order prevOrder;
                        Map.Entry prevEntry = currentState.lowerEntry(curOrder.getPrice());
                        while (prevEntry != null && (prevOrder = (Order)prevEntry.getValue()).getOrderSide() != Side.BUY) {
                            log.warn("CROSS: New curOrder: " + curOrder + " and prev " + prevOrder);
                            valid = false;
                            prevEntry = currentState.lowerEntry(prevOrder.getPrice());
                        }
                        continue;
                    }
                    if (curOrder.getOrderSide() != Side.SELL) continue;
                    Map.Entry nextEntry = currentState.higherEntry(curOrder.getPrice());
                    while (nextEntry != null && (nextOrder = (Order)nextEntry.getValue()).getOrderSide() != Side.SELL) {
                        log.warn("CROSS: New curOrder: " + curOrder + " and prev " + nextOrder);
                        valid = false;
                        nextEntry = currentState.higherEntry(nextOrder.getPrice());
                    }
                }
                curTime = order.getTime();
                curTimeOrders.clear();
            }
            curTimeOrders.add(order);
            if (order.getSize() != 0L) {
                currentState.put(order.getPrice(), order);
                continue;
            }
            currentState.remove(order.getPrice());
        }
        if (timeGap > timeGapBound) {
            log.warn("TIME_GAP_BOUND: " + timeGap);
            valid = false;
        }
        return valid;
    }
}

