package com.dxfeed.orcs.qd;

import com.devexperts.io.IOUtil;
import com.devexperts.qd.util.Decimal;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * @deprecated use {@link com.dxfeed.orcs.api.PriceLevelService#getOrders(CandleSymbol, int, long, long, String)}
 * to retrieve {@link com.dxfeed.event.market.Order} events instead.
 */
@Deprecated
public class PriceLevelCandle implements TimeSeriesEvent<CandleSymbol> {
    public static final int MAX_SEQUENCE = (1 << 22) - 1;


    /*
     * Flags property has several significant bits that are packed into an integer in the following way:
     *   31..11   10...4    3    2    1    0
     * +--------+--------+----+----+----+----+
     * |        |Exchange|  Side   |  Scope  |
     * +--------+--------+----+----+----+----+
     */

    public static final int TYPE_MASK = 3;
    public static final int TYPE_SHIFT = 11;

    // EXCHANGE values are ASCII chars in [0, 127].
    static final int EXCHANGE_MASK = 0x7f;
    static final int EXCHANGE_SHIFT = 4;

    // SIDE values are taken from Side enum.
    static final int SIDE_MASK = 3;
    static final int SIDE_SHIFT = 2;

    // SCOPE values are taken from Scope enum.
    static final int SCOPE_MASK = 3;
    static final int SCOPE_SHIFT = 0;

    private CandleSymbol eventSymbol;
    private int eventFlags;
    private long eventTime;

    //time + millis + sequence
    private long timeSequence;
    private long orderSourceAndIndex;
    private int timeNanoPart;
    private double price = Double.NaN;
    private long size;
    private long count;
    private int flags;
    private int bidSize;
    private int bidCount;
    private int askSize;
    private int askCount;
    private String marketMaker;

    public int getTimeNanoPart() {
        return timeNanoPart;
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    public long getTimeSequence() {
        return timeSequence;
    }

    public void setTimeSequence(long timeSequence) {
        this.timeSequence = timeSequence;
    }

    public OrderSource getSource() {
        int sourceId = (int) (orderSourceAndIndex >> 48);
        if (!OrderSource.isSpecialSourceId(sourceId))
            sourceId = (int) (orderSourceAndIndex >> 32);
        return OrderSource.valueOf(sourceId);
    }

    public long getOrderSourceAndIndex() {
        return orderSourceAndIndex;
    }

    public void setOrderSourceAndIndex(long orderSourceAndIndex) {
        this.orderSourceAndIndex = orderSourceAndIndex;
    }

    @Override
    public int getEventFlags() {
        return eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    public long getIndex() {
        return getTimeSequence();
    }

    @Override
    public void setIndex(long index) {
        this.timeSequence = index;
    }

    @Override
    public long getTime() {
        return (timeSequence >> 32) * 1000 + ((timeSequence >> 22) & 0x3ff);
    }

    public void setTime(long time) {
        timeSequence = ((long) TimeUtil.getSecondsFromTime(time) << 32) | ((long) TimeUtil.getMillisFromTime(time) << 22) | getSequence();
    }

    /**
     * Returns sequence number of this order to distinguish orders that have the same
     * {@link #getTime() time}. This sequence number does not have to be unique and
     * does not need to be sequential. Sequence can range from 0 to {@link #MAX_SEQUENCE}.
     *
     * @return sequence of this order.
     */
    public int getSequence() {
        return (int) timeSequence & MAX_SEQUENCE;
    }

    /**
     * Changes {@link #getSequence()} sequence number} of this order.
     *
     * @param sequence the sequence.
     * @throws IllegalArgumentException if sequence is below zero or above {@link #MAX_SEQUENCE}.
     * @see #getSequence()
     */
    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > MAX_SEQUENCE)
            throw new IllegalArgumentException();
        timeSequence = (timeSequence & ~MAX_SEQUENCE) | sequence;
    }


    public long getSize() {
        return askSize + bidSize;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getCount() {
        return askCount + bidCount;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getFlags() {
        return flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getMarketMaker() {
        return marketMaker;
    }

    public void setMarketMaker(String marketMaker) {
        this.marketMaker = marketMaker;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public int getBidSize() {
        return bidSize;
    }

    public void setBidSize(int bidSize) {
        this.bidSize = bidSize;
    }

    public int getBidCount() {
        return bidCount;
    }

    public void setBidCount(int bidCount) {
        this.bidCount = bidCount;
    }

    public int getAskSize() {
        return askSize;
    }

    public void setAskSize(int askSize) {
        this.askSize = askSize;
    }

    public int getAskCount() {
        return askCount;
    }

    public void setAskCount(int askCount) {
        this.askCount = askCount;
    }

    public Side getSide() {
        return Side.valueOf(Util.getBits(flags, SIDE_MASK, SIDE_SHIFT));
    }

    public PriceLevelCandleType getType() {
        return PriceLevelCandleType.valueOf(Util.getBits(flags, TYPE_MASK, TYPE_SHIFT));
    }

    @Override
    public CandleSymbol getEventSymbol() {
        return eventSymbol;
    }

    @Override
    public void setEventSymbol(CandleSymbol eventSymbol) {
        this.eventSymbol = eventSymbol;
    }

    public Scope getScope() {
        return Scope.valueOf(Util.getBits(flags, SCOPE_MASK, SCOPE_SHIFT));
    }

    @Override
    public String toString() {
        return "Order{" + getEventSymbol() +
            ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(getEventTime()) +
            ", source=" + getSource() +
            ", eventFlags=0x" + Integer.toHexString(getEventFlags()) +
            ", orderIndex=" + (int) orderSourceAndIndex +
            ", time=" + TimeFormat.DEFAULT.withMillis().format(getTime()) +
            ", sequence=" + getSequence() +
            ", timeNanoPart=" + timeNanoPart +
            ", price=" + price +
            ", size=" + size +
            ", count=" + count +
            ", bidSize=" + bidSize +
            ", bidCount=" + bidCount +
            ", askSize=" + askSize +
            ", askCount=" + askCount +
            ", side=" + getSide() +
            ", scope=" + getScope() +
            ", type=" + getType() +
            ", marketMaker='" + marketMaker + "'" +
            "}";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(eventSymbol);
        //eventFlags not needed in RMI
        //eventTime not needed in RMI
        IOUtil.writeCompactLong(out, timeSequence);
        IOUtil.writeCompactLong(out, orderSourceAndIndex);
        //nanoPart not needed in RMI
        IOUtil.writeCompactInt(out, Decimal.compose(price));
        //size and count will calculated
        //flags not needed in RMI
        IOUtil.writeCompactInt(out, bidSize);
        IOUtil.writeCompactInt(out, bidCount);
        IOUtil.writeCompactInt(out, askSize);
        IOUtil.writeCompactInt(out, askCount);
        IOUtil.writeUTFString(out, marketMaker);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        eventSymbol = (CandleSymbol) in.readObject();
        //eventFlags not needed in RMI
        //eventTime not needed in RMI
        timeSequence = IOUtil.readCompactLong(in);
        orderSourceAndIndex = IOUtil.readCompactLong(in);
        //nanoPart not needed in RMI
        price = Decimal.toDouble(IOUtil.readCompactInt(in));
        //size and count will calculated
        //flags not needed in RMI
        bidSize = IOUtil.readCompactInt(in);
        bidCount = IOUtil.readCompactInt(in);
        askSize = IOUtil.readCompactInt(in);
        askCount = IOUtil.readCompactInt(in);
        size = askSize + bidSize;
        count = askCount + bidCount;
        marketMaker = IOUtil.readUTFString(in);
    }
}
