package com.dxfeed.orcs;

import com.devexperts.logging.Logging;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.Order;
import com.dxfeed.orcs.api.PriceLevelService;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Sample class to demonstrate how to subscribe for orders with update information received in configured period
 * described via {@link PriceLevelService#GRANULARITY_ATTRIBUTE_KEY}.
 */
public class OrcsSamples {
    private static final Logging log = Logging.getLogging(OrcsSamples.class);

    private OrcsSamples() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Syntax: OrcsSamples <feedAddress> <symbol>");
            return;
        }
        String feedAddress = args[0];
        String rawSymbol = args[1];

        sampleWithDxFeed(feedAddress, rawSymbol);
        log.info("Exiting...");
    }

    private static void sampleWithDxFeed(String feedAddress, String rawSymbol) throws IOException {
        DXEndpoint endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.STREAM_FEED).withName("orcs-dxfeed").build();
        DXFeed feed = endpoint.connect(feedAddress).getFeed();
        DXFeedSubscription<Order> sub = feed.createSubscription(Order.class);

        List<String> subscriptions = new ArrayList<>(2);
        subscriptions.add(CandleSymbol.valueOf(rawSymbol, CandlePeriod.DAY).toString()); // volume movements
        String volumeMoveGranularitySecondSymbol = CandleSymbol.valueOf(rawSymbol, CandlePeriod.DAY).toString();
        volumeMoveGranularitySecondSymbol = MarketEventSymbols.changeAttributeStringByKey(
            volumeMoveGranularitySecondSymbol, PriceLevelService.GRANULARITY_ATTRIBUTE_KEY, CandlePeriod.parse("s").toString()
        );
        subscriptions.add(volumeMoveGranularitySecondSymbol); //volume movements with seconds granularity

        sub.addEventListener(events -> events.forEach(System.out::println));
        sub.setSymbols(subscriptions);
        //work until user input
        System.in.read();
        //clear
        sub.clear();
        endpoint.close();
    }
}
