/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.orcs;

import com.devexperts.logging.Logging;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.Order;
import java.io.IOException;
import java.util.ArrayList;

public class OrcsSamples {
    private static final Logging log = Logging.getLogging(OrcsSamples.class);

    private OrcsSamples() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Syntax: OrcsSamples <feedAddress> <symbol>");
            return;
        }
        String feedAddress = args[0];
        String rawSymbol = args[1];
        OrcsSamples.sampleWithDxFeed(feedAddress, rawSymbol);
        log.info("Exiting...");
    }

    private static void sampleWithDxFeed(String feedAddress, String rawSymbol) throws IOException {
        DXEndpoint endpoint = DXEndpoint.newBuilder().withRole(DXEndpoint.Role.STREAM_FEED).withName("orcs-dxfeed").build();
        DXFeed feed = endpoint.connect(feedAddress).getFeed();
        DXFeedSubscription sub = feed.createSubscription(Order.class);
        ArrayList<String> subscriptions = new ArrayList<String>(2);
        subscriptions.add(CandleSymbol.valueOf((String)rawSymbol, (CandleSymbolAttribute)CandlePeriod.DAY).toString());
        String volumeMoveGranularitySecondSymbol = CandleSymbol.valueOf((String)rawSymbol, (CandleSymbolAttribute)CandlePeriod.DAY).toString();
        volumeMoveGranularitySecondSymbol = MarketEventSymbols.changeAttributeStringByKey((String)volumeMoveGranularitySecondSymbol, (String)"gr", (String)CandlePeriod.parse((String)"s").toString());
        subscriptions.add(volumeMoveGranularitySecondSymbol);
        sub.addEventListener(events -> events.forEach(System.out::println));
        sub.setSymbols(subscriptions);
        System.in.read();
        sub.clear();
        endpoint.close();
    }
}

