/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.vap;

import java.io.Serializable;
import java.util.Arrays;

public final class OptionStatisticsData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double _52wIVHigh;
    private final double _52wIVLow;
    private final double iv;
    private final double _52wHVHigh;
    private final double _52wHVLow;
    private final double hv;
    private final double putVolume;
    private final double callVolume;
    private final double putCallRatio;
    private final double vwap;
    private final double putBelowBidFrac;
    private final double putBetweenMarketFrac;
    private final double putOverAskFrac;
    private final double callBelowBidFrac;
    private final double callBetweenMarketFrac;
    private final double callOverAskFrac;
    private final double totalBelowBidFrac;
    private final double totalBetweenMarketFrac;
    private final double totalOverAskFrac;
    private final double[] perDeltaPut;
    private final double[] perDeltaCall;

    public OptionStatisticsData(double _52wIVHigh, double _52wIVLow, double iv, double _52wHVHigh, double _52wHVLow, double hv, double putVolume, double callVolume, double putCallRatio, double vwap, double putBelowBid, double putBetweenMarket, double putOverAsk, double callBelowBid, double callBetweenMarket, double callOverAsk, double[] perDeltaPut, double[] perDeltaCall) {
        int i;
        this._52wIVHigh = _52wIVHigh;
        this._52wIVLow = _52wIVLow;
        this.iv = iv;
        this._52wHVHigh = _52wHVHigh;
        this._52wHVLow = _52wHVLow;
        this.hv = hv;
        this.putVolume = putVolume;
        this.callVolume = callVolume;
        this.putCallRatio = putCallRatio;
        this.vwap = vwap;
        double putTotal = putBelowBid + putBetweenMarket + putOverAsk;
        double callTotal = callBelowBid + callBetweenMarket + callOverAsk;
        double total = putTotal + callTotal;
        this.putBelowBidFrac = putTotal == 0.0 ? Double.NaN : putBelowBid / putTotal;
        this.putBetweenMarketFrac = putTotal == 0.0 ? Double.NaN : putBetweenMarket / putTotal;
        this.putOverAskFrac = putTotal == 0.0 ? Double.NaN : putOverAsk / putTotal;
        this.callBelowBidFrac = callTotal == 0.0 ? Double.NaN : callBelowBid / callTotal;
        this.callBetweenMarketFrac = callTotal == 0.0 ? Double.NaN : callBetweenMarket / callTotal;
        this.callOverAskFrac = callTotal == 0.0 ? Double.NaN : callOverAsk / callTotal;
        this.totalBelowBidFrac = total == 0.0 ? Double.NaN : (putBelowBid + callBelowBid) / total;
        this.totalBetweenMarketFrac = total == 0.0 ? Double.NaN : (putBetweenMarket + callBetweenMarket) / total;
        this.totalOverAskFrac = total == 0.0 ? Double.NaN : (putOverAsk + callOverAsk) / total;
        this.perDeltaPut = new double[perDeltaPut.length];
        for (i = 0; i < perDeltaPut.length; ++i) {
            this.perDeltaPut[i] = putTotal == 0.0 ? Double.NaN : perDeltaPut[i] / putTotal;
        }
        this.perDeltaCall = new double[perDeltaCall.length];
        for (i = 0; i < perDeltaCall.length; ++i) {
            this.perDeltaCall[i] = callTotal == 0.0 ? Double.NaN : perDeltaCall[i] / callTotal;
        }
    }

    public double get52wIVHigh() {
        return this._52wIVHigh;
    }

    public double get52wIVLow() {
        return this._52wIVLow;
    }

    public double getIV() {
        return this.iv;
    }

    public double get52wHVHigh() {
        return this._52wHVHigh;
    }

    public double get52wHVLow() {
        return this._52wHVLow;
    }

    public double getHV() {
        return this.hv;
    }

    public double getPutVolume() {
        return this.putVolume;
    }

    public double getCallVolume() {
        return this.callVolume;
    }

    public double getPutCallRatio() {
        return this.putCallRatio;
    }

    public double getVwap() {
        return this.vwap;
    }

    public double getPutBelowBidFrac() {
        return this.putBelowBidFrac;
    }

    public double getPutBetweenMarketFrac() {
        return this.putBetweenMarketFrac;
    }

    public double getPutOverAskFrac() {
        return this.putOverAskFrac;
    }

    public double getCallBelowBidFrac() {
        return this.callBelowBidFrac;
    }

    public double getCallBetweenMarketFrac() {
        return this.callBetweenMarketFrac;
    }

    public double getCallOverAskFrac() {
        return this.callOverAskFrac;
    }

    public double getTotalBelowBidFrac() {
        return this.totalBelowBidFrac;
    }

    public double getTotalBetweenMarketFrac() {
        return this.totalBetweenMarketFrac;
    }

    public double getTotalOverAskFrac() {
        return this.totalOverAskFrac;
    }

    public double[] getPerDeltaPut() {
        return this.perDeltaPut;
    }

    public double[] getPerDeltaCall() {
        return this.perDeltaCall;
    }

    public String toString() {
        return "OptionStatisticsData{_52wIVHigh=" + this._52wIVHigh + ", _52wIVLow=" + this._52wIVLow + ", iv=" + this.iv + ", _52wHVHigh=" + this._52wHVHigh + ", _52wHVLow=" + this._52wHVLow + ", hv=" + this.hv + ", putVolume=" + this.putVolume + ", callVolume=" + this.callVolume + ", putCallRatio=" + this.putCallRatio + ", vwap=" + this.vwap + ", putBelowBidFrac=" + this.putBelowBidFrac + ", putBetweenMarketFrac=" + this.putBetweenMarketFrac + ", putOverAskFrac=" + this.putOverAskFrac + ", callBelowBidFrac=" + this.callBelowBidFrac + ", callBetweenMarketFrac=" + this.callBetweenMarketFrac + ", callOverAskFrac=" + this.callOverAskFrac + ", totalBelowBidFrac=" + this.totalBelowBidFrac + ", totalBetweenMarketFrac=" + this.totalBetweenMarketFrac + ", totalOverAskFrac=" + this.totalOverAskFrac + ", perDeltaPut=" + Arrays.toString(this.perDeltaPut) + ", perDeltaCall=" + Arrays.toString(this.perDeltaCall) + '}';
    }
}

